﻿namespace FailuSistemasSimulacija;

// Attēlo failu sistēmas objektu — mapi vai datu failu
public class FailaObjekts {
    public readonly string nosaukums;
    public readonly List<FailaObjekts> berni = new();
    public FailaObjekts? vecaks;
    private readonly FailaTips tips;

    // Konstruktors faila nosaukuma un tipa inicializēšanai
    public FailaObjekts(string nosaukums, FailaTips tips) {
        this.nosaukums = nosaukums;
        this.tips = tips;
    }

    //parāda visus šīs mapes bērnus
    public void paradit() {
        if (berni.Count == 0) {
            Console.WriteLine("Šajā mapē nav ierakstu.");
            return;
        }

        foreach (FailaObjekts child in berni) {
            if (child.irDatne()) {
                Console.WriteLine($"[DATNE] {child.nosaukums}");
            } else {
                Console.WriteLine($"[MAPE]  {child.nosaukums}");
            }
        }
    }

    // Izdzēš norādīto failu sistēmas objektu no bērnu saraksta
    public void dzest(string nosaukums, bool dzestRealaisFails) {
        FailaObjekts merkis = berni.FirstOrDefault(f => f.nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase));

        if (merkis == null) {
            Console.WriteLine($"Kļūda: Ieraksts '{nosaukums}' netika atrasts.");
            return;
        }

        if (merkis.irMape()) {
            if (merkis.berni.Any()) {
                Console.Write($"Mape '{merkis.nosaukums}' nav tukša. Vai tiešām vēlaties to dzēst kopā ar saturu? (Y/n): ");
                string response = Console.ReadLine();
                if (!response?.Equals("Y", StringComparison.OrdinalIgnoreCase) ?? true) {
                    Console.WriteLine("Dzēšana atcelta.");
                    return;
                }
            }

            berni.Remove(merkis);
            Console.WriteLine($"Mape '{merkis.nosaukums}' ir veiksmīgi izdzēsta.");
        } else if (merkis.irDatne()) {
            if (dzestRealaisFails) {
                string filePath = Path.Combine(Environment.CurrentDirectory, merkis.nosaukums);
                try {
                    if (File.Exists(filePath)) {
                        File.Delete(filePath);
                        Console.WriteLine($"Reālais fails '{filePath}' ir izdzēsts no diska.");
                    }
                } catch (Exception ex) {
                    Console.WriteLine($"Kļūda dzēšot reālo failu '{filePath}': {ex.Message}");
                }
            }

            berni.Remove(merkis);
            Console.WriteLine($"Datne '{merkis.nosaukums}' ir veiksmīgi izdzēsta.");
        }
    }

    //vai pašreizējais objekts ir datu fails
    public bool irDatne() {
        return tips == FailaTips.DATNE;
    }

    //vai pašreizējais objekts ir mape
    public bool irMape() {
        return tips == FailaTips.MAPE;
    }

    // Šajā mapē izveido jaunu bērnu failu sistēmas objektu (mapi vai datu failu)
    public void izveidot(bool isFolder, string entryName) {
        if (irDatne()) {
            Console.WriteLine("Kļūda: Nevar izveidot ierakstus datnē, tikai mapē.");
            return;
        }

        if (berni.Any(f => f.nosaukums.Equals(entryName, StringComparison.OrdinalIgnoreCase))) {
            Console.WriteLine($"Kļūda: Ieraksts ar nosaukumu '{entryName}' jau eksistē.");
            return;
        }

        FailaObjekts newEntry = new(entryName, isFolder ? FailaTips.MAPE : FailaTips.DATNE);
        newEntry.vecaks = this;
        berni.Add(newEntry);
        Console.WriteLine($"{(isFolder ? "Mape" : "Datne")} '{entryName}' ir izveidota.");
    }
}

public class Program {
    // Attēlo pašreizējo direktoriju virtuālajā failu sistēmā
    private static FailaObjekts sobridejais = new("c:", FailaTips.MAPE);

    // Programmas galvenais ieejas punkts
    public static void Main() {
        // Komandu cikls lietotāja mijiedarbībai
        while (true) {
            Console.Write(cels(sobridejais) + "> ");
            var ievade = Console.ReadLine();
            var ievades = ievade?.Split(' ', StringSplitOptions.RemoveEmptyEntries);

            if (ievades == null || ievades.Length == 0) {
                continue;
            }

            string komanda = ievades[0].ToLower();

            try {
                switch (komanda) {
                    case "by":
                    case "exit":
                        Environment.Exit(0);
                        break;

                    case "dir":
                        if (ievades.Length > 2 && ievades[1].ToLower() == ">") {
                            eksportet(sobridejais, ievades[2]);
                        } else if (ievades.Length == 1) {
                            sobridejais.paradit();
                        } else {
                            Console.WriteLine("Nederīga 'dir' komanda. Lietošana: dir vai dir > [datnes_nosaukums]");
                        }

                        break;
                    case "mkdir":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: mkdir [mapes_nosaukums1] [mapes_nosaukums2] ...");
                        } else {
                            for (var i = 1; i < ievades.Length; i++) {
                                sobridejais.izveidot(true, ievades[i]);
                            }
                        }

                        break;
                    case "create":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: create [datnes_nosaukums1] [datnes_nosaukums2] ...");
                        } else {
                            for (var i = 1; i < ievades.Length; i++) {
                                sobridejais.izveidot(false, ievades[i]);
                            }
                        }

                        break;
                    case "rm":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: rm [mapes_nosaukums1] [mapes_nosaukums2] ...");
                        } else {
                            for (var i = 1; i < ievades.Length; i++) {
                                sobridejais.dzest(ievades[i], false);
                            }
                        }

                        break;
                    case "del":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: del [datnes_nosaukums1] [datnes_nosaukums2] ...");
                        } else {
                            for (var i = 1; i < ievades.Length; i++) {
                                sobridejais.dzest(ievades[i], true); // Delete virtual and real file
                            }
                        }

                        break;
                    case "cd":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: cd [mape] vai cd .. vai cd /");
                        } else {
                            parvietoties(ievades[1]);
                        }

                        break;
                    case "edit":
                        if (ievades.Length < 2) {
                            Console.WriteLine("Lietošana: edit [datnes_nosaukums]");
                        } else {
                            skatit(ievades[1]);
                        }

                        break;
                    default:
                        Console.WriteLine($"Nezināma komanda: '{komanda}'.");
                        break;
                }
            }
            catch (IndexOutOfRangeException) {
                Console.WriteLine("Kļūda: Nepareizs komandas arguments. Lūdzu, pārbaudiet sintaksi.");
            }
            catch (Exception ex) {
                Console.WriteLine($"Neparedzēta kļūda: {ex.Message}");
            }
        }
    }

    // Pārvietojas pa virtuālo failu sistēmu
    private static void parvietoties(string galamerkis) {
        if (galamerkis == "..") {
            if (sobridejais.vecaks != null) {
                sobridejais = sobridejais.vecaks;
            } else {
                Console.WriteLine("Jūs jau atrodaties sākuma mapē.");
            }
        } else if (galamerkis == "/") {
            while (sobridejais.vecaks != null) {
                sobridejais = sobridejais.vecaks;
            }
        } else {
            FailaObjekts targetFolder = sobridejais.berni.FirstOrDefault(f => f.nosaukums.Equals(galamerkis, StringComparison.OrdinalIgnoreCase) && f.irMape());
            if (targetFolder != null) {
                sobridejais = targetFolder;
            } else {
                Console.WriteLine($"Kļūda: Mape '{galamerkis}' netika atrasta vai nav mape.");
            }
        }
    }

    // Atgriež pašreizējās direktorijas pilno ceļu
    private static string cels(FailaObjekts failaObjekts) {
        Stack<string> dalas = new Stack<string>();
        FailaObjekts pasr = failaObjekts; //pašreizējais fails

        while (pasr != null) {
            dalas.Push(pasr.nosaukums);
            pasr = pasr.vecaks;
        }

        // Neļauj rādīt "c:/c:", ja 'c:' ir sakne, nevis vienīgais elements
        if (dalas.Peek().Equals("c:", StringComparison.OrdinalIgnoreCase) && dalas.Count > 1) {
            dalas.Pop();
        }

        return string.Join("/", dalas).Replace("c:/", "c:\\");
    }

    // Eksportē pašreizējās direktorijas saturu uz reālu failu diskā
    private static void eksportet(FailaObjekts mape, string nosaukums) {
        FailaObjekts failaObjekts = mape.berni.FirstOrDefault(f => f.nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase) && f.irDatne());

        if (failaObjekts != null) {
            mape.dzest(nosaukums, true);
        }

        mape.izveidot(false, nosaukums);

        string paka = Path.Combine(Environment.CurrentDirectory, nosaukums);

        try {
            // no: https://learn.microsoft.com/en-us/dotnet/standard/io/how-to-write-text-to-a-file
            using (StreamWriter writer = new StreamWriter(paka)) {
                if (mape.berni.Count == 0) {
                    writer.WriteLine("Šajā mapē nav ierakstu.");
                } else {
                    foreach (FailaObjekts child in mape.berni) {
                        writer.WriteLine(child.irDatne() ? $"[DATNE] {child.nosaukums}" : $"[MAPE]  {child.nosaukums}");
                    }
                }
            }

            Console.WriteLine($"'dir' izvads saglabāts reālā datnē: {paka}");
        }
        catch (Exception kļūda) {
            Console.WriteLine($"Kļūda, saglabājot 'dir' izvadu reālā datnē: {kļūda.Message}");
        }
    }

    // Parāda reāla faila saturu diskā
    private static void skatit(string fileName) {
        FailaObjekts failaObjekts = sobridejais.berni.FirstOrDefault(f => f.nosaukums.Equals(fileName, StringComparison.OrdinalIgnoreCase) && f.irDatne());

        if (failaObjekts == null) {
            Console.WriteLine($"Kļūda: Datne '{fileName}' netika atrasta.");
            return;
        }

        Console.WriteLine($"Datnes nosaukums: {failaObjekts.nosaukums}");
        string paka = Path.Combine(Environment.CurrentDirectory, fileName);

        try {
            if (File.Exists(paka)) {
                Console.WriteLine(File.ReadAllText(paka));
            } else {
                Console.WriteLine($"Datne '{paka}' neeksistē. Nevar parādīt saturu.");
            }
        } catch (Exception ex) {
            Console.WriteLine($"Kļūda lasot datnes saturu: {ex.Message}");
        }
    }
}

// Nosaka failu sistēmas ieraksta veidu: mape vai datu fails
public enum FailaTips {
    MAPE, DATNE
}